﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Activities;
using TravelDataLib;

namespace TravelRequestService
{

  public sealed class CompleteTravelRequest : CodeActivity
  {

      // Aktualizowanie zgłoszenia podróży za pomocą informacji o zatwierdzeniu.

    public InArgument<TravelRequestMsg> TravelRequest { get; set; }
    public InArgument<string> ManagerId { get; set; }
    public InArgument<bool> IsApproved { get; set; }

    protected override void Execute(CodeActivityContext context)
    {
        // Pobieranie zgłoszenia podróży z kontekstu.
      TravelRequestMsg tRequest = context.GetValue(this.TravelRequest);

      // Określanie menedżera odpowiedzialnego za zatwierdzenie zgłoszenia.
      tRequest.ApprovalManagerId = context.GetValue(this.ManagerId);

      // Określanie, czy zgłoszenie jest zatwierdzone.
      tRequest.IsApproved = context.GetValue(this.IsApproved);

      // Zapisywanie zgłoszenia podróży.
      TravelRequestDataAccess.Complete(tRequest);
    }
  }
}
